*___________________________________________________________________________________________________
	
	GRUnivariate(dsIn=, maOrder=, price=)

	macro to estimate a univariate generalized Roll model of prices.

	Parameters
	dsIn		Input dataset
	maOrder		Order of moving average estimated
	price		name of price variable (default=p)
				The price variable is assumed to be in
				level (or log) form. The routine computes the first-differences internally.

____________________________________________________________________________________________________;

%macro GRUnivariate(dsIn=, maOrder=5, price=p);
proc arima data=&dsIn;
	identify var=&price(1) center nlag=10;
	estimate noint p=0 q=&maOrder;
	title "Univariate MA analysis of &price Input dataset=&dsIn maOrder=&maOrder";
	ods output parameterEstimates=parameterEstimates;
	ods output fitStatistics=fitStatistics;
	quit;
	run;
title "Univariate random-walk analysis";
proc iml;
	start main;
	reset printadv=1;
	use fitStatistics;
	read next var {nValue1} into varEpsilon;
	print varEpsilon [label="Innovation variance"];
	use parameterEstimates;
	read all var {estimate} into theta;
	theta = -theta;
	rn = char(1:&maOrder);
	print (t(theta)) [colname=rn label='Thetas'];
	sumTheta = 1+sum(theta);
	print sumTheta [label="Sum of thetas, including theta(0)=1" f=50.5];
	varW = sumTheta##2 * varEpsilon;
	print varW [label="Random-walk variance" f=best30.5];
	sdW = sqrt(varW);
	print sdW [label="Random-walk standard deviation" f=best30.5];

	*	Cumulate sums of thetas;
	sCoeff = j(1,&maOrder,0);
	do i=1 to &maOrder;
		do j=i to &maOrder;
			sCoeff[i] = sCoeff[i] + theta[j];
		end;
	end;
	print sCoeff [label="Pricing error coefficients" f=12.5];
	sVar = sum( sCoeff##2 ) * varEpsilon;
	print sVar [label="Pricing error variance (lower bound)" f=50.10];
	sSD = sqrt(sVar);
	print sSD [label="Pricing error standard deviation (lower bound)" f=50.6];
	finish main;
	run; 
	quit;


run;
%mend GRUnivariate;
